// VisaAttributeMetadata.cpp : 
//


#include "stdafx.h"

#include "VisaAttributeMetadata.h"



//// g_tableVisaAttribMetadata[]
//
// Attribute metadata table.
//
VisaAttribMetadataTableEntry g_tableVisaAttribMetadata[] =
{
	// generic attributes (supported by most resources)
	{"VI_ATTR_INTF_INST_NAME", VI_ATTR_INTF_INST_NAME, VisaType_Str, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_INTF_NUM", VI_ATTR_INTF_NUM, VisaType_UInt16, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_RSRC_CLASS", VI_ATTR_RSRC_CLASS, VisaType_Str, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_RSRC_NAME", VI_ATTR_RSRC_NAME, VisaType_Str, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_RSRC_SPEC_VERSION", VI_ATTR_RSRC_SPEC_VERSION, VisaType_UInt32, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_RSRC_IMPL_VERSION", VI_ATTR_RSRC_IMPL_VERSION, VisaType_UInt32, VISA_ATTRIB_F_GLOB_RO | VISA_ATTRIB_F_SHOW_IN_HEX},
	{"VI_ATTR_RSRC_MANF_ID", VI_ATTR_RSRC_MANF_ID, VisaType_UInt16, VISA_ATTRIB_F_GLOB_RO | VISA_ATTRIB_F_SHOW_IN_HEX},
	{"VI_ATTR_RSRC_MANF_NAME", VI_ATTR_RSRC_MANF_NAME, VisaType_Str, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_TMO_VALUE", VI_ATTR_TMO_VALUE, VisaType_UInt32, 0},
	// serial INSTR attributes
	{"VI_ATTR_ASRL_BAUD", VI_ATTR_ASRL_BAUD, VisaType_UInt32, VISA_ATTRIB_F_GLOBAL},
	{"VI_ATTR_ASRL_DATA_BITS", VI_ATTR_ASRL_DATA_BITS, VisaType_UInt16, VISA_ATTRIB_F_GLOBAL},
	{"VI_ATTR_ASRL_END_IN", VI_ATTR_ASRL_END_IN, VisaType_UInt16, 0},
	{"VI_ATTR_ASRL_END_OUT", VI_ATTR_ASRL_END_OUT, VisaType_UInt16, 0},
	{"VI_ATTR_ASRL_FLOW_CNTRL", VI_ATTR_ASRL_FLOW_CNTRL, VisaType_UInt16, VISA_ATTRIB_F_GLOBAL},
	{"VI_ATTR_ASRL_PARITY", VI_ATTR_ASRL_PARITY, VisaType_UInt16, VISA_ATTRIB_F_GLOBAL},
	{"VI_ATTR_ASRL_STOP_BITS", VI_ATTR_ASRL_STOP_BITS, VisaType_UInt16, VISA_ATTRIB_F_GLOBAL},
	// GPIB related attributes
	{"VI_ATTR_GPIB_ADDR_STATE", VI_ATTR_GPIB_ADDR_STATE, VisaType_Int16, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_GPIB_ATN_STATE", VI_ATTR_GPIB_ATN_STATE, VisaType_Int16, VISA_ATTRIB_F_GLOB_RO | VISA_ATTRIB_F_TRI_STATE},
	{"VI_ATTR_GPIB_CIC_STATE", VI_ATTR_GPIB_CIC_STATE, VisaType_Bool, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_GPIB_HS488_CBL_LEN", VI_ATTR_GPIB_HS488_CBL_LEN, VisaType_Int16, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_GPIB_NDAC_STATE", VI_ATTR_GPIB_NDAC_STATE, VisaType_Int16, VISA_ATTRIB_F_GLOB_RO | VISA_ATTRIB_F_TRI_STATE},
	{"VI_ATTR_GPIB_PRIMARY_ADDR", VI_ATTR_GPIB_PRIMARY_ADDR, VisaType_UInt16, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_GPIB_READDR_EN", VI_ATTR_GPIB_READDR_EN, VisaType_Bool, 0},
	{"VI_ATTR_GPIB_RECV_CIC_STATE", VI_ATTR_GPIB_RECV_CIC_STATE, VisaType_Bool, VISA_ATTRIB_F_READONLY},
	{"VI_ATTR_GPIB_REN_STATE", VI_ATTR_GPIB_REN_STATE, VisaType_Bool, 0},
	{"VI_ATTR_GPIB_SECONDARY_ADDR", VI_ATTR_GPIB_SECONDARY_ADDR, VisaType_UInt16, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_GPIB_SRQ_STATE", VI_ATTR_GPIB_SRQ_STATE, VisaType_Int16, VISA_ATTRIB_F_GLOB_RO},	
	{"VI_ATTR_GPIB_SYS_CNTRL_STATE", VI_ATTR_GPIB_SYS_CNTRL_STATE, VisaType_Bool, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_GPIB_UNADDR_EN", VI_ATTR_GPIB_UNADDR_EN, VisaType_Bool, 0},
	// needed by any GPIB implementation
	{"VI_ATTR_SEND_END_EN", VI_ATTR_SEND_END_EN, VisaType_Bool, 0},
	{"VI_ATTR_SUPPRESS_END_EN", VI_ATTR_SUPPRESS_END_EN, VisaType_Bool, 0},
	{"VI_ATTR_TERMCHAR", VI_ATTR_TERMCHAR, VisaType_UInt08, 0},
	{"VI_ATTR_TERMCHAR_EN", VI_ATTR_TERMCHAR_EN, VisaType_Bool, 0},
	// some TCP/IP attributes
	{"VI_ATTR_TCPIP_ADDR", VI_ATTR_TCPIP_ADDR, VisaType_Str, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_TCPIP_DEVICE_NAME", VI_ATTR_TCPIP_DEVICE_NAME, VisaType_Str, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_TCPIP_HOSTNAME", VI_ATTR_TCPIP_HOSTNAME, VisaType_Str, VISA_ATTRIB_F_GLOB_RO},
	{"VI_ATTR_TCPIP_PORT", VI_ATTR_TCPIP_PORT, VisaType_UInt16, VISA_ATTRIB_F_GLOB_RO},
	//
	//{"", , VisaType_Str, 0},
	//
	// terminal entry -- do not delete!
	{NULL, 0, VisaType_Unknown, 0}
};



//// FindAttributeTableEntry
//
// Perform linear search of attribute table to find match on
// attribure name as string.
//
pAttribMetadataTableEntry
FindAttributeTableEntry(
	LPCTSTR pszAttrName
)
{
	pAttribMetadataTableEntry pScan;
	for (pScan = g_tableVisaAttribMetadata; pScan->m_pszSymbolicName != NULL; ++pScan)
	{
		if (strcmp(pszAttrName, pScan->m_pszSymbolicName) == 0)
		{
			return pScan;
		}
	}
	
	return NULL;
}


//// VisaAttributeDataType2String
//
// Convert enumerated type to string containing VISA data type identifier.
//
char*
VisaAttributeDataType2String(
	VisaAttributeDataType fAttrType
)
{
	char* strRet = "ViDataType";
	switch (fAttrType)
	{
		case VisaType_Bool:
			strRet = "ViBoolean";
			break;
		case VisaType_Int08:
			strRet = "ViInt8";
			break;
		case VisaType_UInt08:
			strRet = "ViUInt8";
			break;
		case VisaType_Int16:
			strRet = "ViInt16";
			break;
		case VisaType_UInt16:
			strRet = "ViUInt16";
			break;
		case VisaType_Int32:
			strRet = "ViInt32";
			break;
		case VisaType_UInt32:
			strRet = "ViUInt32";
			break;
		case VisaType_Str:
			strRet = "ViString";
			break;
	}

	return strRet;
}
